require( "HiddenObject/script/style.lua" );

FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};


local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
	yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
	noname = gDialogTable.noname;
end

if (gDialogTable.name) then
	name = gDialogTable.name;
end


YesNoText =
 {
	parent=DefaultStyle,
	font = YesNoFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};

DialogTitleFont = {
  standardFont,
  32,
  Color(131, 167, 184, 255),
};


DialogTitleText = {
	parent=DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=30
};

DialogBodyFont = {
  standardFont,
  24,
  WhiteColor
};

DialogBodyText = {
	parent=DefaultStyle,
	font = DialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};


function GetWindowX()

	x = kCenter;
	if IsMainMenu() then x = 342; end
	return x;
end



function GetWindowY()

	y = kCenter - 45;
	if IsMainMenu() then y = 160; end
	return y;
end

MakeDialog
{
	name="yesNoDialog", -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="HiddenObject/UI/Background/smalldialog",
		--x=kCenter,
		--y=kCenter,
		x = GetWindowX(),
		y = GetWindowY(),
		

		SetStyle(DialogTitleText),
        Text
		{
			name = "deleteyesnotitle",
			label= gDialogTable.title,
			font = DialogTitleFont,
			x = kCenter,
			y = 20,
			h = 36,
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			name = "deleteyesnobody",
			label= gDialogTable.body,
			x = kCenter,
			y = 120,
			h = 36,
		};
		
		Text
		{
			name = "userName",
			label= "",
			x = kCenter,
			y = 75,
			h = 36,
		};

		SetStyle(FooterStyle);
        Button
        {
			command=
				function()
					if (gDialogTable.yes) then 
						gDialogTable.yes() ; 
					end
				end;
            close = true,
            flags = 5,
            label = yes,
            name = yesname,
            font = StandardButtonFont,
            x = kCenter-80,
            y = -80,
        },

        Button
        {
			command=
				function() 
					if (gDialogTable.no) then
						gDialogTable.no() ; 
					end
                end;
            close = true,
            font = StandardButtonFont,
            flags = 5,
            label = no,
            name = noname,
            x = kCenter+80,
            y = -80,
        },
        
    },

} -- MakeDialog


local userName = GetSelectedPlayerName();
SetWindowText("userName", userName);